<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CVOrder;
use Illuminate\Http\Request;

class CVOrderController extends Controller
{
    public function index()
    {
        $orders = CVOrder::latest()->paginate(10);
        return view('admin.orders.index', compact('orders'));
    }

    public function updateStatus(Request $request, CVOrder $order)
    {
        $validated = $request->validate([
            'status' => 'required|in:pending,processing,completed,cancelled'
        ]);

        $order->update($validated);

        return redirect()->back()->with('success', 'Order status updated!');
    }

    public function destroy(CVOrder $order)
    {
    $order->delete();
    
    return redirect()->route('admin.orders.index')
                    ->with('success', 'Pesanan berhasil dihapus!');
    }
}
