<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CVOrder;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_orders' => CVOrder::count(),
            'pending_orders' => CVOrder::where('status', 'pending')->count(),
            'processing_orders' => CVOrder::where('status', 'processing')->count(),
            'completed_orders' => CVOrder::where('status', 'completed')->count(),
        ];

        $recentOrders = CVOrder::latest()->take(5)->get();

        return view('admin.dashboard', compact('stats', 'recentOrders'));
    }
}
