<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Content;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index()
    {
        $whatsappNumber = Content::getValue('whatsapp_number', '6281234567890');
        return view('admin.settings', compact('whatsappNumber'));
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'whatsapp_number' => 'required|string|max:20',
        ]);

        Content::updateOrCreate(
            ['key' => 'whatsapp_number'],
            ['value' => $validated['whatsapp_number']]
        );

        return redirect()->back()->with('success', 'WhatsApp number updated!');
    }
}
