<?php

namespace App\Http\Controllers;

use App\Models\Content;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Show the application homepage.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $contents = [
            'hero_title' => Content::getValue('home_hero_title', 'RG Digital Solution'),
            'hero_subtitle' => Content::getValue('home_hero_subtitle', 'Professional CV Services That Get You Hired'),
            'description' => Content::getValue('home_description', 'We create professional, ATS-friendly CVs that help you stand out and land your dream job. Our expert designers craft CVs that highlight your strengths and achievements.'),
            'services_title' => Content::getValue('home_services_title', 'Our Services'),
            'services_description' => Content::getValue('home_services_description', 'We offer comprehensive CV design and optimization services tailored to your career goals.'),
        ];

        return view('home.index', compact('contents'));
    }
}