<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CVOrder extends Model
{
    use HasFactory;

    protected $table = 'cv_orders';

    protected $fillable = [
        'name',
        'email',
        'phone',
        'job_position',
        'education',
        'education_from',
        'education_to',
        'work_experience_from',
        'worked_experience_to',
        'hard_skills',
        'soft_skills',
        'cv_design',
        'status',
        'file'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    /**
     * Get badge class based on status
     */
    public function getStatusBadgeAttribute()
    {
        $badges = [
            'pending' => 'warning',
            'processing' => 'info',
            'completed' => 'success',
            'cancelled' => 'danger'
        ];
        return $badges[$this->status] ?? 'secondary';
    }
}