<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Content extends Model
{
    use HasFactory;

    protected $fillable = ['key', 'value', 'logo'];

    /**
     * Get content value by key
     */
    public static function getValue($key, $default = '')
    {
        $content = self::where('key', $key)->first();
        return $content ? $content->value : $default;
    }
    
    /**
     * Get logo path by key
     */
    public static function getLogo($key = 'logo')
    {
        $content = self::where('key', $key)->first();
        return $content && $content->logo ? $content->logo : null;
    }
}