<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class WorkExperience extends Model
{
    protected $fillable = [
        'cv_order_id',
        'job_title',
        'company',
        'start_date',
        'end_date',
        'description',
        'order'
    ];

    public function cvOrder(): BelongsTo
    {
        return $this->belongsTo(CVOrder::class);
    }
}