<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
    {
    Schema::table('cv_orders', function (Blueprint $table) {
        $table->text('education')->after('experience')->nullable();
        $table->string('work_experience_from')->after('education')->nullable();
        $table->string('work_experience_to')->after('work_experience_from')->nullable();
    });
    }

public function down()
    {
    Schema::table('cv_orders', function (Blueprint $table) {
        $table->dropColumn(['education', 'work_experience_from', 'work_experience_to']);
    });
    }
};
