<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
    Schema::create('organizational_experiences', function (Blueprint $table) {
        $table->id();
        $table->foreignId('cv_order_id')->constrained('cv_orders')->cascadeOnDelete();
        $table->string('position');
        $table->string('organization');
        $table->string('start_date');
        $table->string('end_date');
        $table->text('description')->nullable();
        $table->integer('order')->default(0);
        $table->timestamps();
    });
    }
};
