<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('cv_orders', function (Blueprint $table) {
            // Hapus kolom lama yang tidak dipakai
            if (Schema::hasColumn('cv_orders', 'experience')) {
                $table->dropColumn('experience');
            }
            if (Schema::hasColumn('cv_orders', 'skills')) {
                $table->dropColumn('skills');
            }
            
            // Tambah kolom yang diperlukan (cek dulu belum ada)
            if (!Schema::hasColumn('cv_orders', 'hard_skills')) {
                $table->text('hard_skills')->nullable()->after('education_to');
            }
            if (!Schema::hasColumn('cv_orders', 'soft_skills')) {
                $table->text('soft_skills')->nullable()->after('hard_skills');
            }
            if (!Schema::hasColumn('cv_orders', 'cv_design')) {
                $table->integer('cv_design')->nullable()->after('soft_skills');
            }
        });
    }

    public function down()
    {
        Schema::table('cv_orders', function (Blueprint $table) {
            $table->dropColumn(['hard_skills', 'soft_skills', 'cv_design']);
            $table->text('experience')->nullable();
            $table->text('skills')->nullable();
        });
    }
};