<?php

namespace Database\Seeders;

use App\Models\Content;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ContentSeeder extends Seeder
{
    public function run()
    {
        // Konfigurasi jumlah maksimal item katalog
        $maxItems = 10;
        
        // Data dasar (home, about, settings)
        $contents = [
            // Home Page Contents
            ['key' => 'home_hero_title', 'value' => 'RG Digital Solution'],
            ['key' => 'home_hero_subtitle', 'value' => 'Professional CV Services That Get You Hired'],
            ['key' => 'home_description', 'value' => 'We create professional, ATS-friendly CVs that help you stand out and land your dream job. Our expert designers craft CVs that highlight your strengths and achievements.'],
            ['key' => 'home_services_title', 'value' => 'Our Services'],
            ['key' => 'home_services_description', 'value' => 'We offer comprehensive CV design and optimization services tailored to your career goals.'],
            
            // About Page Contents
            ['key' => 'about_profile', 'value' => "RG Digital Solution is a professional CV design service founded with the mission to help job seekers create impressive CVs that get noticed by employers. Our team of expert designers and career consultants work together to create CVs that showcase your unique qualifications and experiences.\n\nWe understand that your CV is often the first impression you make on potential employers, which is why we dedicate ourselves to creating documents that are not only visually appealing but also strategically crafted to highlight your strengths and achievements."],
            ['key' => 'about_vision', 'value' => "To become the leading CV design service in Indonesia, helping thousands of job seekers achieve their career aspirations through professionally crafted CVs."],
            ['key' => 'about_mission', 'value' => "Our mission is to provide affordable, high-quality CV design services that help job seekers present themselves effectively to potential employers. We strive to stay updated with the latest industry trends and ATS requirements to ensure our clients' CVs are always competitive."],
            ['key' => 'about_founder_image', 'value' => 'default-founder.jpg'],
            
            // WhatsApp Settings
            ['key' => 'whatsapp_number', 'value' => '6288801026800'],
            
            // Konfigurasi jumlah item katalog
            ['key' => 'cv_catalog_max_items', 'value' => $maxItems],
            
            // CV Catalog Description
            ['key' => 'cv_catalog_description', 'value' => 'Pilih desain CV yang sesuai dengan kepribadian dan industri Anda. Semua desain telah dioptimalkan untuk ATS dan siap digunakan.'],
        ];

        // Generate 100 item katalog secara otomatis
        for ($i = 1; $i <= $maxItems; $i++) {
            // Harga dinamis: Rp 10.000 untuk item 1, naik Rp 5.000 per item
            $basePrice = 10000;
            $priceIncrement = 5000;
            $currentPrice = $basePrice + (($i - 1) * $priceIncrement);
            
            $contents[] = ['key' => 'cv_catalog_' . $i . '_title', 'value' => 'Professional CV Design ' . $i];
            $contents[] = ['key' => 'cv_catalog_' . $i . '_price', 'value' => 'Rp ' . number_format($currentPrice, 0, ',', '.')];
            $contents[] = ['key' => 'cv_catalog_' . $i . '_image', 'value' => 'cv' . $i . '.jpg'];
        }

        // Simpan semua data ke database
        foreach ($contents as $content) {
            Content::updateOrCreate(
                ['key' => $content['key']],
                ['value' => $content['value']]
            );
        }
    }
}
