@extends('layouts.app')

@section('title', 'About Us')

@section('content')
<div class="container my-5">
    <div class="text-center mb-5">
        <h1 class="fw-bold mb-3">About RG Digital Solution</h1>
        <p class="text-muted">Learn more about our company and mission</p>
    </div>

    <div class="row mb-5">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <h4 class="card-title fw-bold mb-4">
                        <i class="fas fa-building me-2 text-primary"></i> Our Profile
                    </h4>
                    <div class="card-text text-muted">
                        {!! nl2br(e($contents['profile'])) !!}
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4 text-center">
                    <h4 class="card-title fw-bold mb-4">
                        <i class="fas fa-user-tie me-2 text-primary"></i> Our Founder
                    </h4>
                    @php
                        $founderImage = \App\Models\Content::getValue('about_founder_image', '');
                    @endphp
                    
                    @if($founderImage && Storage::disk('public')->exists('founders/' . $founderImage))
                        <img src="{{ Storage::url('founders/' . $founderImage) }}" 
                             alt="Founder" 
                             class="img-fluid rounded-circle shadow mb-3"
                             style="width: 300px; height: 300px; object-fit: cover; border: 5px solid #f8f9fa;">
                    @else
                        <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-3 mx-auto" style="width: 300px; height: 300px;">
                            <i class="fas fa-user fa-5x text-primary"></i>
                        </div>
                    @endif
                    <h5 class="fw-bold mb-1">Ridwan Gunawan</h5>
                    <p class="text-muted mb-3">Founder & CEO</p>
                    <p class="text-muted small fst-italic">"Dedicated to helping job seekers achieve their career goals"</p>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <h4 class="card-title fw-bold mb-4">
                        <i class="fas fa-bullseye me-2 text-primary"></i> Our Vision
                    </h4>
                    <div class="card-text text-muted">
                        {!! nl2br(e($contents['vision'])) !!}
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card border-0 shadow-sm">
                <div class="card-body p-4">
                    <h4 class="card-title fw-bold mb-4">
                        <i class="fas fa-rocket me-2 text-primary"></i> Our Mission
                    </h4>
                    <div class="card-text text-muted">
                        {!! nl2br(e($contents['mission'])) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center p-5">
                    <h4 class="fw-bold mb-4">Our Core Values</h4>
                    <div class="row g-4">
                        <div class="col-md-3">
                            <div class="bg-warning bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-3 mx-auto" style="width: 100px; height: 100px;">
                                <i class="fas fa-star fa-3x text-warning"></i>
                            </div>
                            <h6 class="fw-bold">Quality</h6>
                            <p class="text-muted small">We deliver only the highest quality CVs</p>
                        </div>
                        <div class="col-md-3">
                            <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-3 mx-auto" style="width: 100px; height: 100px;">
                                <i class="fas fa-clock fa-3x text-primary"></i>
                            </div>
                            <h6 class="fw-bold">Timeliness</h6>
                            <p class="text-muted small">We respect your time with fast delivery</p>
                        </div>
                        <div class="col-md-3">
                            <div class="bg-danger bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-3 mx-auto" style="width: 100px; height: 100px;">
                                <i class="fas fa-heart fa-3x text-danger"></i>
                            </div>
                            <h6 class="fw-bold">Customer Care</h6>
                            <p class="text-muted small">Your satisfaction is our priority</p>
                        </div>
                        <div class="col-md-3">
                            <div class="bg-info bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center mb-3 mx-auto" style="width: 100px; height: 100px;">
                                <i class="fas fa-lightbulb fa-3x text-info"></i>
                            </div>
                            <h6 class="fw-bold">Innovation</h6>
                            <p class="text-muted small">We stay ahead with the latest trends</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection