@extends('layouts.app')

@section('title', 'Manage About Content')

@section('content')
<div class="container my-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="fw-bold">
            <i class="fas fa-info-circle me-2"></i> Manage About Page Content
        </h1>
        <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Back to Dashboard
        </a>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">
                <i class="fas fa-edit me-2"></i> About Page Sections
            </h5>
        </div>
        <div class="card-body p-4">
            <form action="{{ route('admin.contents.about.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                
                <!-- Profile Section -->
                <div class="mb-4 pb-4 border-bottom">
                    <h5 class="fw-bold text-primary mb-3">
                        <i class="fas fa-building me-2"></i> Profile Section
                    </h5>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">About Profile</label>
                        <input type="hidden" name="contents[0][key]" value="about_profile">
                        <textarea class="form-control" 
                                  name="contents[0][value]" 
                                  rows="6"
                                  placeholder="Company profile description">{{ $contents->where('key', 'about_profile')->first()->value ?? '' }}</textarea>
                        <small class="text-muted">Use line breaks for paragraphs</small>
                    </div>
                </div>

                <!-- Vision & Mission -->
                <div class="mb-4 pb-4 border-bottom">
                    <h5 class="fw-bold text-primary mb-3">
                        <i class="fas fa-bullseye me-2"></i> Vision & Mission
                    </h5>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Vision</label>
                        <input type="hidden" name="contents[1][key]" value="about_vision">
                        <textarea class="form-control" 
                                  name="contents[1][value]" 
                                  rows="4"
                                  placeholder="Company vision statement">{{ $contents->where('key', 'about_vision')->first()->value ?? '' }}</textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Mission</label>
                        <input type="hidden" name="contents[2][key]" value="about_mission">
                        <textarea class="form-control" 
                                  name="contents[2][value]" 
                                  rows="4"
                                  placeholder="Company mission statement">{{ $contents->where('key', 'about_mission')->first()->value ?? '' }}</textarea>
                    </div>
                </div>

                <!-- Founder Image -->
                <div class="mb-4">
                    <h5 class="fw-bold text-primary mb-3">
                        <i class="fas fa-user-tie me-2"></i> Founder Image
                    </h5>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Upload New Image (Max 10MB)</label>
                        <input type="file" class="form-control" name="founder_image" accept="image/*">
                        <small class="text-muted">Recommended size: 500x500px, Format: JPG/PNG/SVG, Max 10MB</small>
                    </div>
                    
                    @php
                        $founderImage = \App\Models\Content::getValue('about_founder_image', '');
                    @endphp
                    
                    @if($founderImage && $founderImage !== 'default-founder.jpg')
                        <div class="mb-3">
                            <label class="form-label fw-medium">Current Image</label>
                            <div class="mt-2 border rounded p-3 bg-light text-center">
                                <img src="{{ Storage::url('founders/' . $founderImage) }}" 
                                     alt="Current Founder Image" 
                                     class="img-fluid rounded-circle shadow"
                                     style="max-width: 300px; max-height: 300px; object-fit: cover; border: 4px solid white;">
                                <p class="mt-2 text-muted small mb-0">Filename: {{ $founderImage }}</p>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-info mt-3">
                            <i class="fas fa-info-circle me-2"></i> Belum ada foto pendiri yang diupload. Upload foto untuk menampilkannya di halaman About.
                        </div>
                    @endif
                </div>

                <!-- Submit Button -->
                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="fas fa-save me-2"></i> Save Changes
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection