@extends('layouts.app')

@section('title', 'Orders Management')

@section('content')
<style>
    /* Perkecil ukuran panah navigasi pagination */
    .pagination .page-link {
        font-size: 0.85rem !important;
        padding: 0.35rem 0.65rem !important;
        min-width: 2.2rem !important;
        height: auto !important;
    }
    
    /* Perkecil icon panah khusus */
    .pagination .page-item .page-link i {
        font-size: 0.8rem !important;
        line-height: 1 !important;
    }
    
    /* Hover effect yang lebih halus */
    .pagination .page-link:hover {
        background-color: #e9ecef !important;
    }
    
    /* Button styling */
    .btn-action {
        padding: 0.35rem 0.65rem !important;
        font-size: 0.9rem !important;
        margin: 0 2px !important;
    }
    
    /* Responsive table */
    @media (max-width: 768px) {
        .table-actions {
            white-space: nowrap;
            min-width: 150px;
        }
    }
</style>

<div class="container my-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="fw-bold">
            <i class="fas fa-file-alt me-2"></i> CV Orders Management
        </h1>
        <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Back to Dashboard
        </a>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0">
                <i class="fas fa-list me-2"></i> All Orders ({{ $orders->total() }})
            </h5>
            <span class="badge bg-light text-dark">{{ $orders->count() }} orders on this page</span>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover table-striped mb-0 align-middle">
                    <thead class="table-light">
                        <tr>
                            <th width="60" class="text-center">#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Position</th>
                            <th width="130" class="text-center">Status</th>
                            <th width="110" class="text-center">Date</th>
                            <th width="150" class="text-center table-actions">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($orders as $order)
                        <tr>
                            <td class="fw-bold text-center align-middle">{{ $order->id }}</td>
                            <td class="align-middle">{{ Str::limit($order->name, 25) }}</td>
                            <td class="align-middle">{{ Str::limit($order->email, 25) }}</td>
                            <td class="align-middle">{{ $order->phone }}</td>
                            <td class="align-middle">{{ Str::limit($order->job_position, 20) }}</td>
                            <td class="align-middle">
                                <form action="{{ route('admin.orders.status.update', $order) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('PATCH')
                                    <select name="status" class="form-select form-select-sm status-select" onchange="this.form.submit()" style="font-size: 0.85rem; padding: 0.25rem 0.5rem;">
                                        <option value="pending" {{ $order->status == 'pending' ? 'selected' : '' }}>⏳ Pending</option>
                                        <option value="processing" {{ $order->status == 'processing' ? 'selected' : '' }}>🔧 Processing</option>
                                        <option value="completed" {{ $order->status == 'completed' ? 'selected' : '' }}>✅ Completed</option>
                                        <option value="cancelled" {{ $order->status == 'cancelled' ? 'selected' : '' }}>❌ Cancelled</option>
                                    </select>
                                </form>
                            </td>
                            <td class="align-middle text-center">
                                <small class="text-muted">{{ $order->created_at->format('M d, Y') }}</small>
                                <div class="text-muted small">{{ $order->created_at->format('H:i') }}</div>
                            </td>
                            <td class="align-middle text-center table-actions">
                                <!-- WhatsApp Button -->
                                <a href="https://wa.me/{{ str_replace(['+', ' '], '', $order->phone) }}" 
                                   target="_blank" 
                                   class="btn btn-success btn-sm btn-action"
                                   title="Chat on WhatsApp">
                                    <i class="fab fa-whatsapp"></i>
                                </a>
                                
                                <!-- Delete Button (Form) -->
                                <form action="{{ route('admin.orders.destroy', $order) }}" 
                                      method="POST" 
                                      class="d-inline"
                                      onsubmit="return confirm('Apakah Anda yakin ingin menghapus pesanan #{{ $order->id }}?\\nNama: {{ $order->name }}\\nPosisi: {{ $order->job_position }}')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm btn-action" title="Delete Order">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center py-5">
                                <div class="mb-3">
                                    <i class="fas fa-inbox fa-4x text-muted opacity-50"></i>
                                </div>
                                <p class="text-muted mb-0 fw-medium">No orders found</p>
                                <p class="text-muted small mt-1">Orders will appear here after customers place their CV orders</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-4 d-flex justify-content-between align-items-center flex-column flex-sm-row">
                <div class="text-muted small mb-2 mb-sm-0">
                    Showing {{ $orders->firstItem() }} to {{ $orders->lastItem() }} of {{ $orders->total() }} orders
                </div>
                <div>
                    {{ $orders->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    // Prevent double submission on status change
    document.addEventListener('DOMContentLoaded', function() {
        const selects = document.querySelectorAll('.status-select');
        selects.forEach(select => {
            select.addEventListener('change', function() {
                this.disabled = true;
                this.closest('form').submit();
            });
        });
    });
</script>
@endsection