@extends('layouts.app')

@section('title', 'Reset Password - RG Digital Solution')

@section('content')
<div class="container-fluid min-vh-100 d-flex align-items-center justify-content-center bg-light">
    <div class="row w-100">
        <!-- Reset Password Form (Full Width) -->
        <div class="col-12 d-flex align-items-center justify-content-center p-4">
            <div class="card shadow-lg border-0 w-100" style="max-width: 450px;">
                <div class="card-body p-5">
                    <div class="text-center mb-4">
                        <h2 class="h3 fw-bold text-primary mb-1">Reset Password</h2>
                        <p class="text-muted">Enter your email to reset your password</p>
                    </div>
                    
                    @if(session('status'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>{{ session('status') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    
                    <form method="POST" action="{{ route('password.email') }}">
                        @csrf
                        
                        <!-- Email Address -->
                        <div class="mb-4">
                            <label for="email" class="form-label fw-medium mb-2">Email Address</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-0"><i class="fas fa-envelope text-muted"></i></span>
                                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus placeholder="Enter your email">
                            </div>
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <!-- Send Reset Link Button -->
                        <button type="submit" class="btn btn-primary w-100 py-3 fw-bold">
                            <i class="fas fa-paper-plane me-2"></i> Send Password Reset Link
                        </button>
                        
                        <!-- Login Link -->
                        <div class="mt-4 text-center">
                            <p class="mb-0 text-muted">Remember your password? 
                                <a href="{{ route('login') }}" class="text-primary fw-medium text-decoration-none">Login</a>
                            </p>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection