@extends('layouts.app')

@section('title', 'RG Digital Solution - Professional CV Services')

@section('content')
<!-- Hero Section -->
<div class="hero-section">
    <div class="container">
        <!-- Logo di tengah -->
        @php
            $logo = \App\Models\Content::getLogo('logo');
        @endphp
        <div class="logo-preview mx-auto mb-4">
            @if($logo && Storage::disk('public')->exists($logo))
                <img src="{{ Storage::url($logo) }}" 
                     alt="RG Digital Solution Logo" 
                     class="hero-logo">
            @else
                <i class="fas fa-code fs-3 text-primary"></i>
            @endif
        </div>
        
        <h1 class="display-4 fw-bold mb-3">
            {{ \App\Models\Content::getValue('home_hero_title', 'RG Digital Solution') }}
        </h1>
        <p class="lead mb-4">
            {{ \App\Models\Content::getValue('home_hero_subtitle', 'Professional CV Services That Get You Hired') }}
        </p>
        <div class="d-flex justify-content-center gap-3 flex-wrap">
            <a href="{{ route('order.create') }}" class="btn btn-light btn-lg px-4">
                <i class="fas fa-file-alt me-2"></i> Buat CV Sekarang
            </a>
            <a href="{{ route('about') }}" class="btn btn-outline-light btn-lg px-4">
                <i class="fas fa-info-circle me-2"></i> Tentang Kami
            </a>
        </div>
    </div>
</div>

<!-- Description Section -->
<div class="container my-5">
    <div class="row justify-content-center">
        <div class="col-lg-8 text-center">
            <h2 class="fw-bold mb-4">Mengapa Memilih Kami?</h2>
            <p class="lead text-muted">
                {{ \App\Models\Content::getValue('home_description', 'Kami membantu profesional membuat CV yang dioptimalkan untuk ATS (Applicant Tracking System) yang menonjol di mata recruiter dan hiring manager.') }}
            </p>
        </div>
    </div>
</div>

<!-- Services Section -->
<div class="bg-light py-5">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold">{{ \App\Models\Content::getValue('home_services_title', 'Layanan Kami') }}</h2>
            <p class="text-muted">
                {{ \App\Models\Content::getValue('home_services_description', 'Layanan desain CV profesional yang disesuaikan dengan industri dan tujuan karir Anda.') }}
            </p>
        </div>
        
        <div class="row g-4">
            <div class="col-md-4">
                <div class="card service-card h-100">
                    <div class="card-body text-center">
                        <i class="fas fa-robot text-primary mb-3"></i>
                        <h5 class="card-title fw-bold mb-3">ATS Optimized</h5>
                        <p class="card-text text-muted">CV Anda akan lolos sistem pelacakan pelamar otomatis yang digunakan perusahaan besar.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card service-card h-100">
                    <div class="card-body text-center">
                        <i class="fas fa-clock text-success mb-3"></i>
                        <h5 class="card-title fw-bold mb-3">Cepat & Mudah</h5>
                        <p class="card-text text-muted">Order dalam 5 menit, CV siap dalam 24 jam. Proses tanpa ribet!</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card service-card h-100">
                    <div class="card-body text-center">
                        <i class="fas fa-money-bill-wave text-warning mb-3"></i>
                        <h5 class="card-title fw-bold mb-3">Harga Terjangkau</h5>
                        <p class="card-text text-muted">Mulai dari Rp 10.000 untuk desain profesional yang berkualitas.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- CV Catalog Preview -->
<div class="container my-5">
    <div class="text-center mb-5">
        <h2 class="fw-bold">Pilih Desain CV Anda</h2>
        <p class="text-muted">Kami menyediakan berbagai desain CV modern yang siap digunakan</p>
    </div>
    
    <div class="row g-4">
        @php
            $maxItems = (int) \App\Models\Content::getValue('cv_catalog_max_items', 3);
        @endphp
        @for($i = 1; $i <= $maxItems; $i++)
            @php
                $title = \App\Models\Content::getValue('cv_catalog_' . $i . '_title', 'CV Design ' . $i);
                $price = \App\Models\Content::getValue('cv_catalog_' . $i . '_price', 'Rp 150.000');
                $image = \App\Models\Content::getValue('cv_catalog_' . $i . '_image', '');
                $imagePath = 'cv-catalog/' . $image;
                $hasImage = !empty(trim($image)) && \Illuminate\Support\Facades\Storage::disk('public')->exists($imagePath);
            @endphp
            @if($hasImage)
                <div class="col-md-4">
                    <div class="card h-100 border-2 border-primary shadow-sm">
                        <div class="card-img-top overflow-hidden" style="height: 200px; background-color: #f8f9fa;">
                            <img src="{{ Storage::url($imagePath) }}" 
                                 alt="{{ $title }}" 
                                 class="img-fluid w-100 h-100" 
                                 style="object-fit: cover;">
                        </div>
                        <div class="card-body p-3 text-center">
                            <h6 class="card-title fw-bold mb-2">{{ $title }}</h6>
                            <p class="card-text text-primary fw-bold fs-5 mb-3">{{ $price }}</p>
                            <a href="{{ route('order.create') }}" class="btn btn-outline-primary btn-sm">
                                <i class="fas fa-shopping-cart me-1"></i> Pilih Desain
                            </a>
                        </div>
                    </div>
                </div>
            @endif
        @endfor
    </div>
    
    <div class="text-center mt-4">
        <a href="{{ route('order.create') }}" class="btn btn-primary px-4 py-2">
            Lihat Semua Desain <i class="fas fa-arrow-right ms-2"></i>
        </a>
    </div>
</div>
@endsection