@extends('layouts.app')

@section('title', 'Home')

@section('content')
<!-- Hero Section -->
<div class="hero-section">
    <div class="container position-relative">
        <h1 class="display-4 fw-bold mb-4">{{ $contents['hero_title'] }}</h1>
        <p class="lead mb-5">{{ $contents['hero_subtitle'] }}</p>
        <a href="{{ route('order.create') }}" class="btn btn-light btn-lg px-5 py-3">
            <i class="fas fa-file-alt me-2"></i> Order Your CV Now
        </a>
    </div>
</div>

<!-- Services Section -->
<div class="container my-5">
    <div class="text-center mb-5">
        <h2 class="fw-bold mb-3">{{ $contents['services_title'] }}</h2>
        <p class="text-muted">{{ $contents['services_description'] }}</p>
    </div>

    <div class="row g-4">
        <div class="col-md-4">
            <div class="card service-card border-0 shadow-sm">
                <div class="card-body text-center p-4">
                    <div class="bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="fas fa-file-alt fa-2x text-primary"></i>
                    </div>
                    <h5 class="card-title fw-bold mb-3">Professional CV Design</h5>
                    <p class="card-text text-muted">Modern and ATS-friendly CV templates designed by professionals</p>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card service-card border-0 shadow-sm">
                <div class="card-body text-center p-4">
                    <div class="bg-info bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="fas fa-magic fa-2x text-info"></i>
                    </div>
                    <h5 class="card-title fw-bold mb-3">CV Optimization</h5>
                    <p class="card-text text-muted">Optimize your CV for specific job applications and industries</p>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card service-card border-0 shadow-sm">
                <div class="card-body text-center p-4">
                    <div class="bg-success bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="fas fa-rocket fa-2x text-success"></i>
                    </div>
                    <h5 class="card-title fw-bold mb-3">Fast Delivery</h5>
                    <p class="card-text text-muted">Get your professional CV delivered within 24 hours</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- About Section -->
<div class="bg-light py-5">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6 mb-4 mb-md-0">
                <h3 class="fw-bold mb-4">Why Choose Us?</h3>
                <p class="lead text-muted mb-4">{{ $contents['description'] }}</p>
                <ul class="list-unstyled">
                    <li class="mb-3">
                        <i class="fas fa-check-circle text-success me-2"></i>
                        <span class="fw-medium">Professional CV designers with industry experience</span>
                    </li>
                    <li class="mb-3">
                        <i class="fas fa-check-circle text-success me-2"></i>
                        <span class="fw-medium">ATS-friendly templates that pass automated screening</span>
                    </li>
                    <li class="mb-3">
                        <i class="fas fa-check-circle text-success me-2"></i>
                        <span class="fw-medium">24-hour delivery guarantee for urgent needs</span>
                    </li>
                    <li class="mb-3">
                        <i class="fas fa-check-circle text-success me-2"></i>
                        <span class="fw-medium">Unlimited revisions until you're satisfied</span>
                    </li>
                </ul>
                <a href="{{ route('order.create') }}" class="btn btn-primary mt-3">
                    <i class="fas fa-shopping-cart me-2"></i> Get Started
                </a>
            </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection