@extends('layouts.app')

@section('title', 'Order CV')

@section('content')
<div class="container my-5">
    <!-- CV Catalog Preview -->
    <div class="card border-0 shadow-sm mb-5">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">
                <i class="fas fa-file-alt me-2"></i> CV Design Catalog
            </h4>
        </div>
        <div class="card-body">
            <p class="text-muted mb-4">{!! nl2br(e(\App\Models\Content::getValue('cv_catalog_description', 'Pilih desain CV yang sesuai dengan kepribadian dan industri Anda. Semua desain telah dioptimalkan untuk ATS dan siap digunakan.'))) !!}</p>
            
            <div class="row g-4">
                @php
                    $maxItems = (int) \App\Models\Content::getValue('cv_catalog_max_items', 3);
                @endphp
                @for($i = 1; $i <= $maxItems; $i++)
                    @php
                        $title = \App\Models\Content::getValue('cv_catalog_' . $i . '_title', '');
                        $price = \App\Models\Content::getValue('cv_catalog_' . $i . '_price', '');
                        $image = \App\Models\Content::getValue('cv_catalog_' . $i . '_image', '');
                        
                        // Cek apakah gambar ada di storage
                        $imagePath = 'cv-catalog/' . $image;
                        $hasImage = !empty(trim($image)) && 
                                   \Illuminate\Support\Facades\Storage::disk('public')->exists($imagePath);
                    @endphp
                    
                    @if($hasImage)
                        <div class="col-md-4">
                            <div class="card h-100 border-2 border-primary shadow-sm">
                                <div class="card-img-top overflow-hidden" style="height: 200px; background-color: #f8f9fa;">
                                    @if($hasImage)
                                        <img src="{{ \Illuminate\Support\Facades\Storage::url($imagePath) }}" 
                                             alt="{{ $title }}" 
                                             class="img-fluid w-100 h-100" 
                                             style="object-fit: cover;">
                                    @else
                                        <div class="d-flex align-items-center justify-content-center h-100">
                                            <div class="text-center p-3">
                                                <i class="fas fa-file-alt fa-4x text-primary opacity-50 mb-2"></i>
                                                <p class="text-muted mb-0">Preview not available</p>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <div class="card-body p-3 text-center">
                                    <h6 class="card-title fw-bold mb-2">{{ $title ?: 'CV Design ' . $i }}</h6>
                                    <p class="card-text text-primary fw-bold fs-5 mb-3">{{ $price ?: 'Rp 150.000' }}</p>
                                    <div class="d-grid">
                                        <button type="button" class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#catalogModal{{ $i }}">
                                            <i class="fas fa-eye me-1"></i> View Details
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Modal for Catalog Details -->
                        <div class="modal fade" id="catalogModal{{ $i }}" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title fw-bold">{{ $title ?: 'CV Design ' . $i }}</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body text-center">
                                        @if($hasImage)
                                            <img src="{{ \Illuminate\Support\Facades\Storage::url($imagePath) }}" 
                                                 alt="{{ $title }}" 
                                                 class="img-fluid rounded mb-3"
                                                 style="max-height: 400px; object-fit: contain;">
                                        @else
                                            <div class="bg-light d-flex align-items-center justify-content-center" style="height: 300px;">
                                                <i class="fas fa-file-alt fa-5x text-muted"></i>
                                            </div>
                                        @endif
                                        <p class="fw-bold text-primary fs-4">{{ $price ?: 'Rp 150.000' }}</p>
                                        <p class="text-muted">Professional CV design optimized for ATS (Applicant Tracking Systems). Includes custom formatting, professional layout, and industry-specific templates.</p>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                @endfor
            </div>
        </div>
    </div>

    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">
                        <i class="fas fa-file-alt me-2"></i> Order Your Professional CV
                    </h4>
                </div>
                <div class="card-body p-4">
                    <div class="alert alert-info mb-4">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>How it works:</strong> Fill out this form and you'll be redirected to WhatsApp to complete your order and make payment. Your selected CV design will be included in the order details.
                    </div>

                    <!-- ✅ FORM TANPA enctype (karena tidak ada upload file) -->
                    <form action="{{ route('order.store') }}" method="POST">
                        @csrf
                        
                        <!-- Personal Information -->
                        <h5 class="fw-bold mb-3 text-primary">
                            <i class="fas fa-user me-2"></i> Personal Information
                        </h5>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="name" class="form-label fw-medium">Full Name <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('name') is-invalid @enderror" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name') }}" 
                                       placeholder="Enter your full name"
                                       required
                                       autofocus>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="email" class="form-label fw-medium">Email Address <span class="text-danger">*</span></label>
                                <input type="email" 
                                       class="form-control @error('email') is-invalid @enderror" 
                                       id="email" 
                                       name="email" 
                                       value="{{ old('email') }}" 
                                       placeholder="Enter your email"
                                       required>
                                @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label for="phone" class="form-label fw-medium">Phone Number <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('phone') is-invalid @enderror" 
                                       id="phone" 
                                       name="phone" 
                                       value="{{ old('phone') }}" 
                                       placeholder="Enter your phone number (e.g., 081234567890)"
                                       required>
                                @error('phone')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="job_position" class="form-label fw-medium">Desired Job Position <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('job_position') is-invalid @enderror" 
                                       id="job_position" 
                                       name="job_position" 
                                       value="{{ old('job_position') }}" 
                                       placeholder="e.g., Software Engineer, Marketing Manager"
                                       required>
                                @error('job_position')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Deskripsi Diri -->
                        <h5 class="fw-bold mb-3 text-primary">
                            <i class="fas fa-user-edit me-2"></i> About Yourself
                        </h5>
                        <div class="mb-4">
                            <label for="about_me" class="form-label fw-medium">About Yourself/Tentang Diri Anda <span class="text-muted">(opsional)</span></label>
                            <textarea class="form-control"
                                      id="about_me"
                                      name="about_me"
                                      rows="5"
                                      placeholder="Ceritakan tentang kepribadian, minat, nilai-nilai, dan motivasi Anda. Bagaimana Anda ingin ditampilkan dalam CV?"></textarea>
                            <small class="text-muted">Contoh: Saya adalah seorang yang kreatif, berpikir kritis, dan senang bekerja dalam tim. Saya sangat tertarik pada teknologi dan ingin berkontribusi dalam pengembangan produk yang inovatif.</small>
                        </div>

                        <!-- Education -->
                        <h5 class="fw-bold mb-3 text-primary">
                            <i class="fas fa-graduation-cap me-2"></i> Education
                        </h5>
                        <div class="mb-4">
                            <label for="education" class="form-label fw-medium">Highest Education <span class="text-danger">*</span></label>
                            <input type="text" 
                                   class="form-control @error('education') is-invalid @enderror" 
                                   id="education" 
                                   name="education" 
                                   value="{{ old('education') }}"
                                   placeholder="e.g., S1 Ilmu Komputer, Universitas XYZ"
                                   required>
                            @error('education')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="text-muted">Pendidikan terakhir yang Anda miliki</small>
                        </div>

                        <!-- Education Dates -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label for="education_from" class="form-label fw-medium">Start Date <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('education_from') is-invalid @enderror" 
                                       id="education_from" 
                                       name="education_from" 
                                       value="{{ old('education_from') }}"
                                       placeholder="e.g., Jan 2020"
                                       required>
                                @error('education_from')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="education_to" class="form-label fw-medium">End Date <span class="text-danger">*</span></label>
                                <input type="text" 
                                       class="form-control @error('education_to') is-invalid @enderror" 
                                       id="education_to" 
                                       name="education_to" 
                                       value="{{ old('education_to') }}"
                                       placeholder="e.g., Dec 2023 / Present"
                                       required>
                                @error('education_to')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Work Experience (Multiple) -->
                        <h5 class="fw-bold mb-3 text-primary">
                            <i class="fas fa-briefcase me-2"></i> Work Experience "Jika belum memilik Pengalaman Kerja silahkan isi belum memiliki pengalaman/Fresh Graduate"
                        </h5>
                        <div id="work-experience-container">
                            <div class="work-experience-group mb-4 p-3 border rounded">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <h6 class="mb-0 fw-medium">Experience 1</h6>
                                    <button type="button" class="btn btn-sm btn-danger remove-work-experience" style="display:none;">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">Job Title</label>
                                        <input type="text"
                                               class="form-control"
                                               name="work_experiences[0][job_title]"
                                               placeholder="e.g., Software Engineer/Belum memiliki pengalaman kerja/Fresh Graduate"
                                               required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">Company</label>
                                        <input type="text"
                                               class="form-control"
                                               name="work_experiences[0][company]"
                                               placeholder="e.g., PT ABC/Belum memiliki pengalaman Kerja/Fresh Graduate"
                                               required>
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">Start Date</label>
                                        <input type="text"
                                               class="form-control"
                                               name="work_experiences[0][start_date]"
                                               placeholder="e.g., Jan 2020/Belum memiliki pengalaman/Fresh Graduate"
                                               required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">End Date</label>
                                        <input type="text"
                                               class="form-control"
                                               name="work_experiences[0][end_date]"
                                               placeholder="e.g., Present / Dec 2023/Belum memiliki pengalaman/Fresh Graduate"
                                               required>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label fw-medium">Description</label>
                                    <textarea class="form-control"
                                              name="work_experiences[0][description]"
                                              rows="3"
                                              placeholder="Describe your responsibilities and achievements/Belum memiliki pengalaman/Fresh Graduate..."></textarea>
                                </div>
                            </div>
                        </div>
                        <button type="button" id="add-work-experience" class="btn btn-outline-primary mb-4">
                            <i class="fas fa-plus me-1"></i> Add Another Work Experience
                        </button>

                        <!-- Organizational Experience (Multiple) -->
                        <h5 class="fw-bold mb-3 text-primary">
                            <i class="fas fa-landmark me-2"></i> Organizational Experience "Jika tidak memiliki pengalaman organisasi silahkan isi Tidak ada"
                        </h5>
                        <div id="organizational-experience-container">
                            <div class="organizational-experience-group mb-4 p-3 border rounded">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <h6 class="mb-0 fw-medium">Experience 1</h6>
                                    <button type="button" class="btn btn-sm btn-danger remove-organizational-experience" style="display:none;">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">Position</label>
                                        <input type="text"
                                               class="form-control"
                                               name="organizational_experiences[0][position]"
                                               placeholder="e.g., Chairman/Tidak ada"
                                               required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">Organization</label>
                                        <input type="text"
                                               class="form-control"
                                               name="organizational_experiences[0][organization]"
                                               placeholder="e.g., Student Council/Tidak ada"
                                               required>
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">Start Date</label>
                                        <input type="text"
                                               class="form-control"
                                               name="organizational_experiences[0][start_date]"
                                               placeholder="e.g., Jan 2020/Tidak ada"
                                               required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">End Date</label>
                                        <input type="text"
                                               class="form-control"
                                               name="organizational_experiences[0][end_date]"
                                               placeholder="e.g., Present / Dec 2023/Tidak ada"
                                               required>
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label fw-medium">Description</label>
                                    <textarea class="form-control"
                                              name="organizational_experiences[0][description]"
                                              rows="3"
                                              placeholder="Describe your role and achievements/Tidak ada..."></textarea>
                                </div>
                            </div>
                        </div>
                        <button type="button" id="add-organizational-experience" class="btn btn-outline-primary mb-4">
                            <i class="fas fa-plus me-1"></i> Add Another Organizational Experience
                        </button>

                        <!-- Skills & Competencies (Categorized) -->
                        <h5 class="fw-bold mb-3 text-primary">
                            <i class="fas fa-cogs me-2"></i> Skills & Competencies
                        </h5>
                        
                        <!-- Hard Skills -->
                        <div class="mb-4">
                            <label class="form-label fw-medium">Hard Skills</label>
                            <textarea class="form-control"
                                      name="hard_skills"
                                      rows="3"
                                      placeholder="List your technical skills, programming languages, tools, software...&#10;e.g., PHP, Laravel, JavaScript, MySQL, Adobe Photoshop"
                                      required>{{ old('hard_skills') }}</textarea>
                            <small class="text-muted">Separate skills with commas or new lines</small>
                        </div>
                        
                        <!-- Soft Skills -->
                        <div class="mb-4">
                            <label class="form-label fw-medium">Soft Skills</label>
                            <textarea class="form-control"
                                      name="soft_skills"
                                      rows="3"
                                      placeholder="List your interpersonal skills, communication, leadership...&#10;e.g., Teamwork, Public Speaking, Problem Solving, Time Management"
                                      required>{{ old('soft_skills') }}</textarea>
                            <small class="text-muted">Separate skills with commas or new lines</small>
                        </div>
                        
                        <!-- Certifications -->
                        <h5 class="fw-bold mt-4 mb-3 text-primary">
                            <i class="fas fa-certificate me-2"></i> Certifications "Jika tidak memiliki sertifikasi silahkan isi Tidak ada"
                        </h5>
                        <div id="certifications-container">
                            <div class="certification-group mb-4 p-3 border rounded">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <h6 class="mb-0 fw-medium">Certification 1</h6>
                                    <button type="button" class="btn btn-sm btn-danger remove-certification" style="display:none;">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">Certification Name</label>
                                        <input type="text"
                                               class="form-control"
                                               name="certifications[0][name]"
                                               placeholder="e.g., Google Data Analytics/Tidak ada"
                                               required>
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label fw-medium">Issue Date</label>
                                        <input type="text"
                                               class="form-control"
                                               name="certifications[0][issue_date]"
                                               placeholder="e.g., Jan 2023/Tidak ada">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="form-label fw-medium">Expiry Date</label>
                                        <input type="text"
                                               class="form-control"
                                               name="certifications[0][expiry_date]"
                                               placeholder="e.g., Jan 2026/Tidak ada">
                                    </div>
                                </div>
                                
                                <div class="mb-3">
                                    <label class="form-label fw-medium">Description</label>
                                    <textarea class="form-control"
                                              name="certifications[0][description]"
                                              rows="2"
                                              placeholder="e.g., Issued by Google via Coursera/Tidak ada"></textarea>
                                </div>
                            </div>
                        </div>
                        <button type="button" id="add-certification" class="btn btn-outline-primary mb-4">
                            <i class="fas fa-plus me-1"></i> Add Another Certification
                        </button>
                        
                        <!-- Languages -->
                        <h5 class="fw-bold mt-4 mb-3 text-primary">
                            <i class="fas fa-language me-2"></i> Languages
                        </h5>
                        <div id="languages-container">
                            <div class="language-group mb-4 p-3 border rounded">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <h6 class="mb-0 fw-medium">Language 1</h6>
                                    <button type="button" class="btn btn-sm btn-danger remove-language" style="display:none;">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">Language</label>
                                        <input type="text"
                                               class="form-control"
                                               name="languages[0][name]"
                                               placeholder="e.g., Indonesia/English"
                                               required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label fw-medium">Proficiency</label>
                                        <select class="form-control" name="languages[0][proficiency]" required>
                                            <option value="">Select proficiency level</option>
                                            <option value="Basic">Basic</option>
                                            <option value="Intermediate">Intermediate</option>
                                            <option value="Advanced">Advanced</option>
                                            <option value="Native">Native/Fluent</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button type="button" id="add-language" class="btn btn-outline-primary mb-4">
                            <i class="fas fa-plus me-1"></i> Add Another Language
                        </button>

                        <!-- CV Selection -->
                        <h5 class="fw-bold mb-3 text-primary">
                            <i class="fas fa-palette me-2"></i> Select Your CV Design
                        </h5>
                        <div class="mb-4">
                            <div class="row g-3">
                                @php
                                    $availableItems = [];
                                    for ($i = 1; $i <= $maxItems; $i++) {
                                        $image = \App\Models\Content::getValue('cv_catalog_' . $i . '_image', '');
                                        $imagePath = 'cv-catalog/' . $image;
                                        $hasImage = !empty(trim($image)) && 
                                                   \Illuminate\Support\Facades\Storage::disk('public')->exists($imagePath);
                                        if ($hasImage) {
                                            $availableItems[] = $i;
                                        }
                                    }
                                @endphp
                                
                                @foreach($availableItems as $i)
                                    @php
                                        $title = \App\Models\Content::getValue('cv_catalog_' . $i . '_title', 'CV Design ' . $i);
                                        $price = \App\Models\Content::getValue('cv_catalog_' . $i . '_price', 'Rp 150.000');
                                    @endphp
                                    <div class="col-md-4">
                                        <div class="form-check border rounded p-3 h-100 d-flex align-items-center justify-content-center text-center">
                                            <input class="form-check-input" type="radio" name="cv_design" id="cv_design_{{ $i }}" value="{{ $i }}" {{ $i == $availableItems[0] ?? 1 ? 'checked' : '' }}>
                                            <label class="form-check-label w-100" for="cv_design_{{ $i }}">
                                                <div class="fw-bold">{{ $title }}</div>
                                                <div class="text-primary fw-bold mt-1">{{ $price }}</div>
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <small class="text-muted">Pilih desain CV yang ingin Anda pesan. Anda dapat melihat detail desain dengan mengklik "View Details" pada katalog di atas.</small>
                        </div>

                        <!-- Submit Button -->
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="fab fa-whatsapp me-2"></i> Order Now via WhatsApp
                            </button>
                        </div>
                    </form>
                </div>
                <div class="card-footer bg-light text-center py-3">
                    <small class="text-muted">
                        <i class="fas fa-lock me-1"></i> Your information is secure and will only be used for your CV order
                    </small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Dynamic Form JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Work Experience
    let workExperienceCount = 1;
    document.getElementById('add-work-experience').addEventListener('click', function() {
        const container = document.getElementById('work-experience-container');
        const newGroup = document.createElement('div');
        newGroup.className = 'work-experience-group mb-4 p-3 border rounded';
        newGroup.innerHTML = `
            <div class="d-flex justify-content-between align-items-start mb-3">
                <h6 class="mb-0 fw-medium">Experience ${workExperienceCount + 1}</h6>
                <button type="button" class="btn btn-sm btn-danger remove-work-experience">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-medium">Job Title <span class="text-danger">*</span></label>
                    <input type="text"
                           class="form-control"
                           name="work_experiences[${workExperienceCount}][job_title]"
                           placeholder="e.g., Software Engineer"
                           required>
                </div>
                <div class="col-md-6">
                    <label class="form-label fw-medium">Company <span class="text-danger">*</span></label>
                    <input type="text"
                           class="form-control"
                           name="work_experiences[${workExperienceCount}][company]"
                           placeholder="e.g., PT ABC"
                           required>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-medium">Start Date <span class="text-danger">*</span></label>
                    <input type="text"
                           class="form-control"
                           name="work_experiences[${workExperienceCount}][start_date]"
                           placeholder="e.g., Jan 2020"
                           required>
                </div>
                <div class="col-md-6">
                    <label class="form-label fw-medium">End Date <span class="text-danger">*</span></label>
                    <input type="text"
                           class="form-control"
                           name="work_experiences[${workExperienceCount}][end_date]"
                           placeholder="e.g., Present / Dec 2023"
                           required>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label fw-medium">Description</label>
                <textarea class="form-control"
                          name="work_experiences[${workExperienceCount}][description]"
                          rows="3"
                          placeholder="Describe your responsibilities and achievements..."></textarea>
            </div>
        `;
        container.appendChild(newGroup);
        workExperienceCount++;
        
        // Add remove functionality
        newGroup.querySelector('.remove-work-experience').addEventListener('click', function() {
            if (workExperienceCount > 1) {
                this.closest('.work-experience-group').remove();
                workExperienceCount--;
            }
        });
    });

    // Organizational Experience
    let orgExperienceCount = 1;
    document.getElementById('add-organizational-experience').addEventListener('click', function() {
        const container = document.getElementById('organizational-experience-container');
        const newGroup = document.createElement('div');
        newGroup.className = 'organizational-experience-group mb-4 p-3 border rounded';
        newGroup.innerHTML = `
            <div class="d-flex justify-content-between align-items-start mb-3">
                <h6 class="mb-0 fw-medium">Experience ${orgExperienceCount + 1}</h6>
                <button type="button" class="btn btn-sm btn-danger remove-organizational-experience">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-medium">Position <span class="text-danger">*</span></label>
                    <input type="text"
                           class="form-control"
                           name="organizational_experiences[${orgExperienceCount}][position]"
                           placeholder="e.g., Chairman"
                           required>
                </div>
                <div class="col-md-6">
                    <label class="form-label fw-medium">Organization <span class="text-danger">*</span></label>
                    <input type="text"
                           class="form-control"
                           name="organizational_experiences[${orgExperienceCount}][organization]"
                           placeholder="e.g., Student Council"
                           required>
                </div>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-medium">Start Date <span class="text-danger">*</span></label>
                    <input type="text"
                           class="form-control"
                           name="organizational_experiences[${orgExperienceCount}][start_date]"
                           placeholder="e.g., Jan 2020"
                           required>
                </div>
                <div class="col-md-6">
                    <label class="form-label fw-medium">End Date <span class="text-danger">*</span></label>
                    <input type="text"
                           class="form-control"
                           name="organizational_experiences[${orgExperienceCount}][end_date]"
                           placeholder="e.g., Present / Dec 2023"
                           required>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label fw-medium">Description</label>
                <textarea class="form-control"
                          name="organizational_experiences[${orgExperienceCount}][description]"
                          rows="3"
                          placeholder="Describe your role and achievements..."></textarea>
            </div>
        `;
        container.appendChild(newGroup);
        orgExperienceCount++;
        
        // Add remove functionality
        newGroup.querySelector('.remove-organizational-experience').addEventListener('click', function() {
            if (orgExperienceCount > 1) {
                this.closest('.organizational-experience-group').remove();
                orgExperienceCount--;
            }
        });
    });

    // Certifications
    let certCount = 1;
    document.getElementById('add-certification').addEventListener('click', function() {
        const container = document.getElementById('certifications-container');
        const newGroup = document.createElement('div');
        newGroup.className = 'certification-group mb-4 p-3 border rounded';
        newGroup.innerHTML = `
            <div class="d-flex justify-content-between align-items-start mb-3">
                <h6 class="mb-0 fw-medium">Certification ${certCount + 1}</h6>
                <button type="button" class="btn btn-sm btn-danger remove-certification">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-medium">Certification Name <span class="text-danger">*</span></label>
                    <input type="text"
                           class="form-control"
                           name="certifications[${certCount}][name]"
                           placeholder="e.g., Google Data Analytics"
                           required>
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-medium">Issue Date</label>
                    <input type="text"
                           class="form-control"
                           name="certifications[${certCount}][issue_date]"
                           placeholder="e.g., Jan 2023">
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-medium">Expiry Date</label>
                    <input type="text"
                           class="form-control"
                           name="certifications[${certCount}][expiry_date]"
                           placeholder="e.g., Jan 2026">
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label fw-medium">Description</label>
                <textarea class="form-control"
                          name="certifications[${certCount}][description]"
                          rows="2"
                          placeholder="e.g., Issued by Google via Coursera"></textarea>
            </div>
        `;
        container.appendChild(newGroup);
        certCount++;
        
        // Add remove functionality
        newGroup.querySelector('.remove-certification').addEventListener('click', function() {
            if (certCount > 1) {
                this.closest('.certification-group').remove();
                certCount--;
            }
        });
    });

    // Languages
    let langCount = 1;
    document.getElementById('add-language').addEventListener('click', function() {
        const container = document.getElementById('languages-container');
        const newGroup = document.createElement('div');
        newGroup.className = 'language-group mb-4 p-3 border rounded';
        newGroup.innerHTML = `
            <div class="d-flex justify-content-between align-items-start mb-3">
                <h6 class="mb-0 fw-medium">Language ${langCount + 1}</h6>
                <button type="button" class="btn btn-sm btn-danger remove-language">
                    <i class="fas fa-trash"></i>
                </button>
            </div>
            
            <div class="row mb-3">
                <div class="col-md-6">
                    <label class="form-label fw-medium">Language <span class="text-danger">*</span></label>
                    <input type="text"
                           class="form-control"
                           name="languages[${langCount}][name]"
                           placeholder="e.g., English"
                           required>
                </div>
                <div class="col-md-6">
                    <label class="form-label fw-medium">Proficiency <span class="text-danger">*</span></label>
                    <select class="form-control" name="languages[${langCount}][proficiency]" required>
                        <option value="">Select proficiency level</option>
                        <option value="Basic">Basic</option>
                        <option value="Intermediate">Intermediate</option>
                        <option value="Advanced">Advanced</option>
                        <option value="Native">Native/Fluent</option>
                    </select>
                </div>
            </div>
        `;
        container.appendChild(newGroup);
        langCount++;
        
        // Add remove functionality
        newGroup.querySelector('.remove-language').addEventListener('click', function() {
            if (langCount > 1) {
                this.closest('.language-group').remove();
                langCount--;
            }
        });
    });

    // Auto-focus on first name field
    document.getElementById('name').focus();
});
</script>
@endsection