<?php

use App\Http\Controllers\HomeController;
use App\Http\Controllers\AboutController;
use App\Http\Controllers\CVOrderController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Public Routes (TANPA auth - bisa diakses semua orang)
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/about', [AboutController::class, 'index'])->name('about');
Route::get('/order-cv', [CVOrderController::class, 'create'])->name('order.create');
Route::post('/order-cv', [CVOrderController::class, 'store'])->name('order.store');

// Authentication Routes (dari Laravel UI)
Auth::routes();

// Admin Routes (HANYA untuk user yang login)
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    // Dashboard
    Route::get('/dashboard', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
    
    // Content Management Routes
    Route::prefix('contents')->name('contents.')->group(function () {
        Route::get('/home', [\App\Http\Controllers\Admin\ContentController::class, 'home'])->name('home');
        Route::post('/home', [\App\Http\Controllers\Admin\ContentController::class, 'updateHome'])->name('home.update');
        Route::get('/about', [\App\Http\Controllers\Admin\ContentController::class, 'about'])->name('about');
        Route::post('/about', [\App\Http\Controllers\Admin\ContentController::class, 'updateAbout'])->name('about.update');
    });
    
    // CV Catalog Routes
    Route::get('/catalog', [\App\Http\Controllers\Admin\CatalogController::class, 'index'])->name('catalog');
    Route::post('/catalog', [\App\Http\Controllers\Admin\CatalogController::class, 'update'])->name('catalog.update');
    
    // Settings Routes
    Route::get('/settings', [\App\Http\Controllers\Admin\SettingsController::class, 'index'])->name('settings');
    Route::post('/settings', [\App\Http\Controllers\Admin\SettingsController::class, 'update'])->name('settings.update');
    
    // Order Management Routes
    Route::prefix('orders')->name('orders.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\CVOrderController::class, 'index'])->name('index');
        Route::patch('/{order}/status', [\App\Http\Controllers\Admin\CVOrderController::class, 'updateStatus'])->name('status.update');
        // ✅ ROUTE HAPUS DIPINDAH KE SINI (BENAR)
        Route::delete('/{order}', [\App\Http\Controllers\Admin\CVOrderController::class, 'destroy'])->name('destroy');
    });
});

// Redirect /home ke root setelah login
Route::get('/home', function () {
    return redirect()->route('home');
});


