

<?php $__env->startSection('title', 'CV Catalog Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container my-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="fw-bold">
            <i class="fas fa-file-alt me-2"></i> CV Catalog Management
        </h1>
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Back to Dashboard
        </a>
    </div>

    <div class="alert alert-info mb-4">
        <i class="fas fa-info-circle me-2"></i>
        <strong>Catalog Configuration:</strong> Saat ini Anda mengelola <strong><?php echo e($maxItems); ?></strong> desain CV. Untuk mengubah jumlah item, edit nilai <code>cv_catalog_max_items</code> di tabel <code>contents</code> via phpMyAdmin.
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h5 class="mb-0">CV Catalog Items (<?php echo e($maxItems); ?> items)</h5>
            <span class="badge bg-light text-dark">Item 1 - <?php echo e($maxItems); ?></span>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('admin.catalog.update')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                
                <?php
                    $index = 0;
                ?>

                <?php for($i = 1; $i <= $maxItems; $i++): ?>
                    <!-- Catalog Item -->
                    <div class="mb-5 pb-4 border-bottom">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h6 class="fw-bold text-primary mb-0">Item <?php echo e($i); ?></h6>
                            <span class="badge bg-primary">ID: <?php echo e($i); ?></span>
                        </div>
                        
                        <!-- Title -->
                        <div class="mb-3">
                            <label class="form-label fw-medium">Title</label>
                            <input type="hidden" name="contents[<?php echo e($index); ?>][key]" value="cv_catalog_<?php echo e($i); ?>_title">
                            <textarea class="form-control" name="contents[<?php echo e($index); ?>][value]" rows="1" required><?php echo e($contents->firstWhere('key', 'cv_catalog_'.$i.'_title')?->value ?? 'Professional CV Design '.$i); ?></textarea>
                        </div>
                        <?php $index++; ?>
                        
                        <!-- Price -->
                        <div class="mb-3">
                            <label class="form-label fw-medium">Price</label>
                            <input type="hidden" name="contents[<?php echo e($index); ?>][key]" value="cv_catalog_<?php echo e($i); ?>_price">
                            <textarea class="form-control" name="contents[<?php echo e($index); ?>][value]" rows="1" required><?php echo e($contents->firstWhere('key', 'cv_catalog_'.$i.'_price')?->value ?? 'Rp '.number_format(10000 + (($i-1)*5000), 0, ',', '.')); ?></textarea>
                            <small class="text-muted">Format: Rp 10.000 (gunakan titik sebagai pemisah ribuan)</small>
                        </div>
                        <?php $index++; ?>
                        
                        <!-- Image -->
                        <div class="mb-3">
                            <label class="form-label fw-medium">Preview Image</label>
                            <input type="file" class="form-control" name="cv_catalog_<?php echo e($i); ?>_image" accept="image/*">
                            <?php
                                $imageValue = $contents->firstWhere('key', 'cv_catalog_'.$i.'_image')?->value ?? '';
                                $imagePath = 'cv-catalog/' . $imageValue;
                                $imageExists = !empty(trim($imageValue)) && Storage::disk('public')->exists($imagePath);
                            ?>
                            <?php if($imageExists): ?>
                                <div class="mt-3">
                                    <label class="form-label fw-medium">Current Preview:</label>
                                    <div class="border rounded p-2 bg-light position-relative">
                                        <img src="<?php echo e(Storage::url($imagePath)); ?>" 
                                             alt="CV <?php echo e($i); ?>" 
                                             class="img-fluid rounded shadow-sm"
                                             style="max-height: 150px; object-fit: contain;">
                                        <div class="mt-2">
                                            <small class="text-muted">Filename: <?php echo e($imageValue); ?></small>
                                        </div>
                                        
                                        <!-- ✅ CHECKBOX HAPUS GAMBAR -->
                                        <div class="form-check mt-3">
                                            <input class="form-check-input" type="checkbox" name="remove_image_<?php echo e($i); ?>" id="remove_image_<?php echo e($i); ?>" value="1">
                                            <label class="form-check-label text-danger" for="remove_image_<?php echo e($i); ?>">
                                                <i class="fas fa-trash me-1"></i> Hapus gambar ini
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="mt-3 alert alert-warning p-2">
                                    <i class="fas fa-image me-2"></i>
                                    <small>Belum ada gambar diupload untuk item ini.</small>
                                </div>
                            <?php endif; ?>
                            <small class="text-muted d-block mt-2">Recommended: 400x600px, JPG/PNG, max 10MB</small>
                        </div>
                    </div>
                <?php endfor; ?>

                <!-- Catalog Description -->
                <div class="mb-5 pb-4 border-bottom">
                    <h6 class="fw-bold text-primary mb-3">Catalog Description</h6>
                    <div class="mb-3">
                        <label class="form-label fw-medium">Description (shown on order page)</label>
                        <input type="hidden" name="contents[<?php echo e($index); ?>][key]" value="cv_catalog_description">
                        <textarea class="form-control" name="contents[<?php echo e($index); ?>][value]" rows="4" required><?php echo e($contents->firstWhere('key', 'cv_catalog_description')?->value ?? 'Pilih desain CV yang sesuai dengan kepribadian dan industri Anda. Semua desain telah dioptimalkan untuk ATS dan siap digunakan.'); ?></textarea>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="fas fa-save me-2"></i> Save All Changes (<?php echo e($maxItems); ?> Items)
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card border-0 shadow-sm mt-4">
        <div class="card-header bg-success text-white">
            <h5 class="mb-0">
                <i class="fas fa-lightbulb me-2"></i> Tips for Managing Catalog
            </h5>
        </div>
        <div class="card-body">
            <ul class="list-unstyled mb-0">
                <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i> <strong>Untuk menambah item:</strong> Edit nilai <code>cv_catalog_max_items</code> di tabel <code>contents</code> via phpMyAdmin (misal: dari 100 ke 150), lalu refresh halaman ini.</li>
                <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i> <strong>Untuk menghapus item:</strong> Centang checkbox <strong>"Hapus gambar ini"</strong> untuk mengosongkan gambar, atau biarkan field Title & Price kosong untuk menyembunyikan item.</li>
                <li class="mb-2"><i class="fas fa-check-circle text-success me-2"></i> <strong>Gambar placeholder:</strong> Item tanpa gambar tidak akan ditampilkan di halaman order CV.</li>
                <li><i class="fas fa-check-circle text-success me-2"></i> <strong>Urutan item:</strong> Item ditampilkan sesuai nomor ID (1, 2, 3, ...). Untuk mengubah urutan, edit nomor ID di key database (misal: ganti <code>cv_catalog_5_*</code> menjadi <code>cv_catalog_2_*</code>).</li>
            </ul>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\rg-digitalsolution\resources\views/admin/catalog.blade.php ENDPATH**/ ?>