

<?php $__env->startSection('title', 'Manage Home Content'); ?>

<?php $__env->startSection('content'); ?>
<div class="container my-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="fw-bold">
            <i class="fas fa-home me-2"></i> Manage Home Page Content
        </h1>
        <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Back to Dashboard
        </a>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">
                <i class="fas fa-edit me-2"></i> Home Page Sections
            </h5>
        </div>
        <div class="card-body p-4">
            <form action="<?php echo e(route('admin.contents.home.update')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                
                <!-- Logo Upload -->
                <div class="mb-5 pb-4 border-bottom">
                    <h5 class="fw-bold text-primary mb-3">
                        <i class="fas fa-image me-2"></i> Website Logo
                    </h5>
                    <p class="text-muted mb-4">Upload logo untuk ditampilkan di navbar dan halaman utama. Format: PNG, JPG, SVG (max 2MB)</p>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Upload Logo Baru</label>
                        <input type="file" class="form-control" name="logo" accept="image/*">
                        <small class="text-muted">Rekomendasi: Logo transparan dengan rasio 1:1</small>
                    </div>
                    
                    <?php
                        $currentLogo = \App\Models\Content::getLogo('logo');
                    ?>
                    
                    <?php if($currentLogo): ?>
                        <div class="mt-4">
                            <label class="form-label fw-medium">Logo Saat Ini:</label>
                            <div class="d-flex align-items-center gap-4 flex-wrap">
                                <!-- Preview Navbar -->
                                <div class="text-center">
                                    <div class="logo-container" style="width: 48px; height: 48px; margin: 0 auto;">
                                        <img src="<?php echo e(Storage::url($currentLogo)); ?>" 
                                             alt="Logo Navbar Preview" 
                                             class="navbar-logo">
                                    </div>
                                    <small class="text-muted">Tampilan di Navbar</small>
                                </div>
                                
                                <!-- Preview Hero -->
                                <div class="text-center">
                                    <div class="logo-preview">
                                        <img src="<?php echo e(Storage::url($currentLogo)); ?>" 
                                             alt="Logo Hero Preview" 
                                             class="hero-logo">
                                    </div>
                                    <small class="text-muted">Tampilan di Halaman Utama</small>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info mt-3">
                            <i class="fas fa-info-circle me-2"></i> Belum ada logo yang diupload. Logo default (ikon kode) akan ditampilkan.
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Hero Section -->
                <div class="mb-5 pb-4 border-bottom">
                    <h5 class="fw-bold text-primary mb-3">
                        <i class="fas fa-heading me-2"></i> Hero Section
                    </h5>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Hero Title</label>
                        <input type="hidden" name="contents[0][key]" value="home_hero_title">
                        <textarea class="form-control" 
                                  name="contents[0][value]" 
                                  rows="2"
                                  placeholder="Main headline for hero section"><?php echo e($contents->where('key', 'home_hero_title')->first()->value ?? 'RG Digital Solution'); ?></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Hero Subtitle</label>
                        <input type="hidden" name="contents[1][key]" value="home_hero_subtitle">
                        <textarea class="form-control" 
                                  name="contents[1][value]" 
                                  rows="2"
                                  placeholder="Subheading for hero section"><?php echo e($contents->where('key', 'home_hero_subtitle')->first()->value ?? 'Professional CV Services That Get You Hired'); ?></textarea>
                    </div>
                </div>

                <!-- Description Section -->
                <div class="mb-5 pb-4 border-bottom">
                    <h5 class="fw-bold text-primary mb-3">
                        <i class="fas fa-align-left me-2"></i> Description Section
                    </h5>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Home Description</label>
                        <input type="hidden" name="contents[2][key]" value="home_description">
                        <textarea class="form-control" 
                                  name="contents[2][value]" 
                                  rows="3"
                                  placeholder="Description about why choose us"><?php echo e($contents->where('key', 'home_description')->first()->value ?? 'We help professionals create ATS-optimized CVs that stand out to recruiters and hiring managers.'); ?></textarea>
                    </div>
                </div>

                <!-- Services Section -->
                <div class="mb-5 pb-4 border-bottom">
                    <h5 class="fw-bold text-primary mb-3">
                        <i class="fas fa-cogs me-2"></i> Services Section
                    </h5>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Services Title</label>
                        <input type="hidden" name="contents[3][key]" value="home_services_title">
                        <textarea class="form-control" 
                                  name="contents[3][value]" 
                                  rows="2"
                                  placeholder="Title for services section"><?php echo e($contents->where('key', 'home_services_title')->first()->value ?? 'Our Services'); ?></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Services Description</label>
                        <input type="hidden" name="contents[4][key]" value="home_services_description">
                        <textarea class="form-control" 
                                  name="contents[4][value]" 
                                  rows="3"
                                  placeholder="Description for services section"><?php echo e($contents->where('key', 'home_services_description')->first()->value ?? 'Professional CV design services tailored to your industry and career goals.'); ?></textarea>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="fas fa-save me-2"></i> Save All Changes
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\rg-digitalsolution\resources\views/admin/contents/home.blade.php ENDPATH**/ ?>