<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="RG Digital Solution - Professional CV Services">
    <title><?php echo $__env->yieldContent('title', 'RG Digital Solution'); ?> - Professional CV Services</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary-blue: #2563eb;
            --secondary-blue: #3b82f6;
            --light-blue: #bfdbfe;
            --dark-blue: #1e40af;
        }
        
        .navbar {
            background: linear-gradient(135deg, var(--primary-blue), var(--secondary-blue));
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            position: fixed !important;
            top: 0 !important;
            width: 100% !important;
            z-index: 1000 !important;
        }
        
        .navbar-brand {
            font-weight: 700;
            font-size: 1.3rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .navbar-logo {
            height: 32px;
            width: 32px;
            object-fit: cover;
            border-radius: 50%;
        }
        
        .navbar-nav .nav-link {
            font-weight: 500;
            transition: color 0.3s ease;
        }
        
        .navbar-nav .nav-link:hover {
            color: var(--light-blue) !important;
        }
        
        .hero-section {
            background: linear-gradient(135deg, var(--primary-blue), var(--secondary-blue));
            color: white;
            padding: 100px 0;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .hero-logo {
            height: 150px;
            width: 150px;
            object-fit: cover;
            border-radius: 50%;
            margin: 0 auto 30px;
            display: block;
            max-width: 100%;
        }
        
        .hero-section .display-4 {
            font-weight: 800;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
        }
        
        .hero-section .lead {
            font-size: 1.5rem;
            margin-top: 20px;
            text-shadow: 1px 1px 3px rgba(0,0,0,0.2);
        }
        
        .service-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: none;
            border-radius: 10px;
            overflow: hidden;
            height: 100%;
        }
        
        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.15);
        }
        
        .service-card .card-body {
            padding: 2rem;
        }
        
        .service-card i {
            font-size: 3rem;
            margin-bottom: 1rem;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--primary-blue), var(--dark-blue));
            border: none;
            padding: 12px 30px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(37, 99, 235, 0.4);
        }
        
        .btn-light {
            background: white;
            color: var(--primary-blue);
            border: 2px solid white;
            padding: 12px 30px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-light:hover {
            background: var(--light-blue);
            color: white;
            transform: translateY(-2px);
        }
        
        .footer {
            background: #0f172a;
            color: #cbd5e1;
            padding: 60px 0 40px;
        }
        
        .footer h5 {
            color: white;
            margin-bottom: 20px;
            font-weight: 700;
            font-size: 1.25rem;
        }
        
        .footer .text-muted {
            color: #94a3b8 !important;
        }
        
        .footer a {
            color: #94a3b8;
            text-decoration: none;
            transition: color 0.3s ease;
            display: block;
            margin-bottom: 10px;
            font-weight: 500;
        }
        
        .footer a:hover {
            color: white;
        }
        
        .footer .social-icon {
            display: inline-block;
            width: 48px;
            height: 48px;
            background: rgba(255,255,255,0.1);
            border-radius: 50%;
            text-align: center;
            line-height: 48px;
            font-size: 1.5rem;
            color: white;
            transition: all 0.3s ease;
            text-decoration: none !important;
        }
        
        .footer .social-icon:hover {
            background: var(--primary-blue);
            transform: translateY(-3px);
        }
        
        .footer .contact-item {
            display: flex;
            align-items: flex-start;
            margin-bottom: 15px;
        }
        
        .footer .contact-icon {
            color: var(--primary-blue);
            font-size: 1.25rem;
            min-width: 28px;
            margin-top: 3px;
        }
        
        .footer .copyright {
            border-top: 1px solid rgba(255,255,255,0.1);
            padding-top: 25px;
            margin-top: 30px;
            color: #64748b;
            font-size: 0.9rem;
        }
        
        .badge {
            padding: 0.5em 0.8em;
            font-weight: 600;
        }
        
        .alert {
            border-radius: 8px;
            border: none;
        }
        
        .card {
            border-radius: 10px;
            border: none;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
        }
        
        .card-header {
            border-radius: 10px 10px 0 0 !important;
        }
        
        /* Mobile responsiveness */
        @media (max-width: 768px) {
            .navbar-logo {
                height: 28px;
                width: 28px;
            }
            .hero-logo {
                height: 120px;
                width: 120px;
            }
            .footer .social-icon {
                width: 42px;
                height: 42px;
                line-height: 42px;
                font-size: 1.3rem;
            }
        }
        
        /* Logo container for perfect circle */
        .logo-container {
            width: 48px;
            height: 48px;
            overflow: hidden;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
    </style>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark sticky-top">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('home')); ?>">
                <?php
                    $logo = \App\Models\Content::getLogo('logo');
                ?>
                <div class="logo-container me-2">
                    <?php if($logo && Storage::disk('public')->exists($logo)): ?>
                        <img src="<?php echo e(Storage::url($logo)); ?>" 
                             alt="RG Digital Solution Logo" 
                             class="navbar-logo">
                    <?php else: ?>
                        <i class="fas fa-code"></i>
                    <?php endif; ?>
                </div>
                <span>RG Digital Solution</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('home') ? 'active' : ''); ?>" href="<?php echo e(route('home')); ?>">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('about') ? 'active' : ''); ?>" href="<?php echo e(route('about')); ?>">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(request()->routeIs('order.*') ? 'active' : ''); ?>" href="<?php echo e(route('order.create')); ?>">Order CV</a>
                    </li>

                    <?php if(auth()->guard()->check()): ?>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="adminDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fas fa-user-circle me-2"></i> <?php echo e(Auth::user()->name); ?>

                            </a>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.dashboard')); ?>"><i class="fas fa-tachometer-alt me-2"></i>Dashboard</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.contents.home')); ?>"><i class="fas fa-home me-2"></i>Manage Home</a></li>
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.contents.about')); ?>"><i class="fas fa-info-circle me-2"></i>Manage About</a></li>
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.catalog')); ?>"><i class="fas fa-file-alt me-2"></i>CV Catalog</a></li>
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.settings')); ?>"><i class="fas fa-cog me-2"></i>Settings</a></li>
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.orders.index')); ?>"><i class="fas fa-file-alt me-2"></i>Orders</a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <form action="<?php echo e(route('logout')); ?>" method="POST" class="dropdown-item">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-link text-dark p-0 w-100 text-start">
                                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('login')); ?>">
                                <i class="fas fa-sign-in-alt"></i> Login
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main style="padding-top: 70px;">
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i><?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <!-- Company Info -->
                <div class="col-md-4 mb-4 mb-md-0">
                    <h5>RG Digital Solution</h5>
                    <p class="mb-4">Professional CV Services that help you land your dream job.</p>
                    <div class="d-flex gap-3">
                        <a href="https://www.instagram.com/rdwngnwn04?igsh=MWUzNWRmYWNoc2Y5dw==" target="_blank" class="social-icon" title="Instagram">
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="https://www.linkedin.com/in/ridwan-gunawan-962275381" target="_blank" class="social-icon" title="LinkedIn">
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                    </div>
                </div>
                
                <!-- Quick Links -->
                <div class="col-md-4 mb-4 mb-md-0">
                    <h5>Quick Links</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="mb-2"><a href="<?php echo e(route('about')); ?>">About</a></li>
                        <li class="mb-2"><a href="<?php echo e(route('order.create')); ?>">Order CV</a></li>
                        <li class="mb-2"><a href="mailto:info@rgdigitalsolution.com">Contact Us</a></li>
                    </ul>
                </div>
                
                <!-- Contact Info -->
                <div class="col-md-4">
                    <h5>Contact Us</h5>
                    <div class="contact-item">
                        <i class="fas fa-phone contact-icon"></i>
                        <span>+62 888-0102-6800</span>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-envelope contact-icon"></i>
                        <span>ridwangunawan2705@gmail.com</span>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-envelope contact-icon"></i>
                        <span>63231030@bsi.ac.id</span>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-map-marker-alt contact-icon"></i>
                        <span>Karawang, Jawa Barat</span>
                    </div>
                </div>
            </div>
            
            <div class="copyright text-center mt-4 pt-3 border-top">
                &copy; <?php echo e(date('Y')); ?> RG Digital Solution. All rights reserved.
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\laragon\www\rg-digitalsolution\resources\views/layouts/app.blade.php ENDPATH**/ ?>